/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.ConnectionPoints;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskFolderNode;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.integrator.VWCMAdminPropertyPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.VWManagerUtil;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.VWConnectionPointDialog;
import filenet.vw.base.PathUtils;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.server.Configuration;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWCMAdminNode
extends VWTaskFolderNode {
    private static final String ATTRIB_CEURI = "CEURI";
    private static final String ATTRIB_OPTIONS = "Options";
    private String m_ceURI = null;
    public static final String XML_NODE_NAME = "ComponentManagers";
    VWCMAdminPropertyPanel m_propertyPanel = null;
    String m_options = "ah0FqAXOml9OqQzIokPyegOSaNiQ";
    private Vector m_componentManagers = new Vector(1);
    private WSListenerProperties m_listenerProperties = null;

    public VWCMAdminNode(String propertiesPath) throws Exception {
        super(VWResource.ComponentManagers, propertiesPath);
        this.m_ceURI = VWCMAdminNode.GetDefaultCEURI();
        this.setExpandAtStartup(true);
        this.fromXML(this.getXMLHandler());
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWCMAdminPropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, false);
        }
    }

    private void addComponentManagerNode(VWManagerNode n) {
        this.m_componentManagers.add(n);
        this.add(n);
    }

    private void fromXML(VWTaskXMLHandler xmlHandler) {
        Node[] definitionNodes;
        if (xmlHandler == null) {
            return;
        }
        Node routerAdminNode = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), XML_NODE_NAME);
        if (routerAdminNode == null || routerAdminNode.getNodeType() != 1) {
            Node n = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), "ComponentManager");
            if (n != null) {
                try {
                    this.addComponentManagerNode(new VWManagerNode(n, this.getPropertyFilePath(), this, null, null));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return;
        }
        Element ele = (Element)routerAdminNode;
        if (ele.getAttributeNode(ATTRIB_CEURI) != null) {
            this.setCEURI(ele.getAttribute(ATTRIB_CEURI));
        }
        if (ele.getAttributeNode(ATTRIB_OPTIONS) != null) {
            this.setOptions(ele.getAttribute(ATTRIB_OPTIONS));
        }
        int nDefs = (definitionNodes = VWTaskXMLHandler.getNodesNamed(routerAdminNode, "ComponentManager")) == null ? 0 : definitionNodes.length;
        for (int i = 0; i < nDefs; ++i) {
            try {
                this.addComponentManagerNode(new VWManagerNode(definitionNodes[i], this.getPropertyFilePath(), this, null, null));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        theBuffer.append("\t").append("<").append(XML_NODE_NAME);
        theBuffer.append(" ").append(ATTRIB_CEURI).append("=\"").append(VWTaskXMLHandler.toXMLString(this.m_ceURI)).append("\" ");
        theBuffer.append(ATTRIB_OPTIONS).append("=\"").append(VWTaskXMLHandler.toXMLString(this.getOptions())).append("\">\n");
        Enumeration e = this.m_componentManagers.elements();
        while (e.hasMoreElements()) {
            VWManagerNode cm = (VWManagerNode)e.nextElement();
            cm.toXML(theBuffer);
        }
        theBuffer.append("\t</ComponentManagers>\n");
    }

    public void displayHelp() {
        VWHelp.displayPage(this.getHelpPath("cm.htm"));
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.NEW) == 0) {
                this.createNewCM();
            }
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.NEW, "Add Separator", VWTaskActionCommand.HELP};
        return actions;
    }

    public void start() throws Exception {
        boolean errorOccurred = false;
        Enumeration e = this.m_componentManagers.elements();
        while (e.hasMoreElements()) {
            VWManagerNode cm = null;
            try {
                cm = (VWManagerNode)e.nextElement();
                if (cm.isStarted() || !cm.getAutoStartEnabled()) continue;
                cm.start();
            }
            catch (Exception ex) {
                errorOccurred = true;
                System.err.println(new VWString("filenet.vw.apps.taskman.cm.VWCMAdminNode.UnableToStartComponentManager", "Unable to start Component Manager {0}: {1}").toString(cm.getName(), ex.getLocalizedMessage()));
                VWDebug.logException(ex);
            }
        }
        if (errorOccurred) {
            throw new VWException("filenet.vw.apps.taskman.cm.VWCMAdminNode.AtLeastOneComponentManagerFailedToStart", "At least one Component Manager failed to start");
        }
    }

    public void stop() throws Exception {
        boolean errorOccurred = false;
        Enumeration e = this.m_componentManagers.elements();
        while (e.hasMoreElements()) {
            VWManagerNode cm = null;
            try {
                cm = (VWManagerNode)e.nextElement();
                if (!cm.isStarted()) continue;
                cm.stop();
            }
            catch (Exception ex) {
                errorOccurred = true;
                System.out.println(new VWString("filenet.vw.apps.taskman.cm.VWCMAdminNode.UnableToStopCM", "Unable to stop Component Manager {0}: {1}").toString(cm.getName(), ex.getLocalizedMessage()));
                VWDebug.logException(ex);
            }
        }
        if (errorOccurred) {
            throw new VWException("filenet.vw.apps.taskman.cm.VWCMAdminNode.AtLeastOneCMFailedToStop", "At least one Component Manager failed to stop");
        }
    }

    public boolean getAutoStartEnabled() {
        Enumeration ports = this.m_componentManagers.elements();
        while (ports.hasMoreElements()) {
            VWManagerNode cm = (VWManagerNode)ports.nextElement();
            if (!cm.getAutoStartEnabled()) continue;
            return true;
        }
        return false;
    }

    private void createNewCM() throws Exception {
        String userName = null;
        String password = null;
        String options = this.m_propertyPanel.getOptions();
        VWAuthItem item = new VWManagerUtil(0).getDString(options);
        if (item != null) {
            userName = item.getName();
            password = item.getPassword();
        }
        if (userName == null) {
            userName = "";
        } else if (userName.compareTo("\"\"") == 0) {
            userName = "";
        }
        if (password == null) {
            password = "";
        } else if (password.compareTo("\"\"") == 0) {
            password = "";
        }
        String cpName = "UNDEFINED";
        try {
            ConnectionPoint[] cps = ConnectionPoints.GetConnectionPoints(this.m_ceURI, userName, password);
            VWConnectionPointDialog dlg = new VWConnectionPointDialog(cps, null);
            dlg.show();
            if (dlg.getCloseStatus() == 0) {
                cpName = dlg.getSelectedConnectionPoint().Name;
                System.out.println("Selected connection point is: " + cpName);
                VWManagerNode m = new VWManagerNode(null, this.getPropertyFilePath(), this, cpName, options);
                this.addComponentManagerNode(m);
                VWTaskCore.getInstance().setFocus(m);
            }
        }
        catch (Exception e) {
            String exMsg = VWException.DescribeThrowableAndItsCause(e);
            String msg = new VWString("filenet.vw.apps.taskman.cm.VWCMAdminNode.UnableToAddANewComponentManager", "Unable to add a new Component Manager: {0}").toString(exMsg);
            this.displayError(msg, true);
            throw e;
        }
    }

    protected void deleteCM(VWManagerNode cmn) throws Exception {
        int i = this.m_componentManagers.indexOf(cmn);
        int nItems = this.m_componentManagers.size();
        this.m_componentManagers.remove(cmn);
        if (i == nItems - 1 && i == 0) {
            return;
        }
        if (i == nItems - 1 && i > 0) {
            --i;
        }
        VWTaskCore.getInstance().setFocus((VWManagerNode)this.m_componentManagers.get(i));
    }

    protected VWManagerNode getCM(String cpName) throws VWException {
        if (cpName.equals("UNDEFINED")) {
            throw new VWException("filenet.vw.apps.taskman.cm.VWCMAdminNode.UNDEFINED", "Please enter a valid connection point.");
        }
        Enumeration e = this.m_componentManagers.elements();
        while (e.hasMoreElements()) {
            VWManagerNode n = (VWManagerNode)e.nextElement();
            if (!n.getName().equals(cpName)) continue;
            return n;
        }
        return null;
    }

    protected String getOptions() {
        return this.m_options;
    }

    protected void setOptions(String s) {
        this.m_options = s;
    }

    protected String getCEURI() {
        return this.m_ceURI;
    }

    protected void setCEURI(String s) {
        this.m_ceURI = s == null || s.trim().length() == 0 ? VWCMAdminNode.GetDefaultCEURI() : s;
    }

    protected static String GetDefaultCEURI() {
        try {
            return Configuration.GetCEURI(null, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected WSListenerProperties getListenerProperties(String cpName) {
        try {
            if (this.m_listenerProperties == null) {
                String disableWS = this.getProperty("TaskManager.ComponentManager.DisableWebServices");
                if (disableWS != null && disableWS.equals("true")) {
                    return null;
                }
                PathUtils myPaths = new PathUtils();
                String myCP = this.getProperty("TaskManager.ComponentManager.ClassPath");
                if (myCP != null) {
                    myPaths.addPath(myCP);
                }
                this.m_listenerProperties = WSListenerProperties.instance(myPaths, cpName);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while retrieving WSListenerProperties.");
        }
        return this.m_listenerProperties;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   29 Sep 2006 17:27:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }
}

